SELECT 
	T1.FirstName, 
	T1.LastName, 
	T2.Gender
FROM Person.Contact T1 INNER JOIN 
	HumanResources.Employee T2 ON T1.ContactID = T2.ContactID
WHERE T1.ContactID IN (1001, 1002, 1003)


SELECT 
	T1.FirstName, 
	T1.LastName, 
	T2.Gender
FROM Person.Contact T1 INNER JOIN 
	HumanResources.Employee T2 ON T1.ContactID = T2.ContactID
WHERE T1.ContactID IN (1001, 1002, 1003)
FOR XML RAW


SELECT 
	FirstName, 
	LastName, 
	Gender
FROM Person.Contact INNER JOIN 
	HumanResources.Employee ON Person.Contact.ContactID = HumanResources.Employee.ContactID
WHERE Person.Contact.ContactID IN (1001, 1002, 1003)
FOR XML AUTO


SELECT 
	FirstName, 
	LastName, 
	Gender
FROM Person.Contact INNER JOIN 
	HumanResources.Employee ON Person.Contact.ContactID = HumanResources.Employee.ContactID
WHERE Person.Contact.ContactID IN (1001, 1002, 1003)
FOR XML AUTO, ROOT ('People'), ELEMENTS, TYPE


SELECT 
	FirstName, 
	LastName, 
	Gender
FROM Person.Contact INNER JOIN 
	HumanResources.Employee ON Person.Contact.ContactID = HumanResources.Employee.ContactID
WHERE Person.Contact.ContactID IN (1001, 1002, 1003)
FOR XML AUTO, ELEMENTS, XMLDATA


SELECT 
	FirstName as "@FName",
	LastName as "@LName"
FROM Person.Contact
WHERE ContactID = 10
FOR XML PATH 


SELECT
	ContactID as "@ContactID",
	FirstName,
	LastName
FROM Person.Contact
WHERE ContactID = 10
FOR XML PATH ('Person')


SELECT
	ContactID as "@ContactID",
	FirstName as "Name/FirstName",
	LastName as "Name/LastName"
FROM Person.Contact
WHERE ContactID = 10
FOR XML PATH ('Person')


SELECT
	T1.ContactID as "@ContactID",
	T2.Gender as "Name/@Gender",
	T1.FirstName as "Name/FirstName",
	T1.LastName as "Name/LastName"
FROM Person.Contact T1 INNER JOIN 
	HumanResources.Employee T2 ON T1.ContactID = T2.ContactID
WHERE T1.ContactID = 1001
FOR XML PATH ('Person')


SELECT
	T1.ContactID as "@ContactID",
	T1.FirstName as "Name/FirstName",
	T2.Gender as "Name/@Gender",
	T1.LastName as "Name/LastName"
FROM Person.Contact T1 INNER JOIN 
	HumanResources.Employee T2 ON T1.ContactID = T2.ContactID
WHERE T1.ContactID = 1001
FOR XML PATH ('Person')


SELECT
	T1.ContactID as "@ContactID",
	T2.Gender as "Name/@Gender",
	T1.Suffix as "Name/Suffix",
	T1.FirstName as "Name/FirstName",
	T1.LastName as "Name/LastName"
FROM Person.Contact T1 INNER JOIN 
	HumanResources.Employee T2 ON T1.ContactID = T2.ContactID
WHERE T1.ContactID = 1260
FOR XML PATH ('')


SELECT
	T1.ContactID as "@ContactID",
	T2.Gender as "Name/@Gender",
	T1.Suffix as "Name/Suffix",
	T1.FirstName as "Name/FirstName",
	T1.LastName as "Name/LastName"
FROM Person.Contact T1 INNER JOIN 
	HumanResources.Employee T2 ON T1.ContactID = T2.ContactID
WHERE T1.ContactID = 1001
FOR XML PATH ('Person'), ELEMENTS XSINIL


SELECT
	T1.ContactID as "@ContactID",
	T1.FirstName as "Name/FirstName",
	T3.AddressLine1 as "Address/Line1",
	T3.City as "Address/City",
	T1.LastName as "Name/LastName"
FROM Person.Contact T1 INNER JOIN 
	HumanResources.EmployeeAddress T2 ON T1.ContactID = T2.EmployeeID
	INNER JOIN Person.Address T3 ON T2.AddressID = T3.AddressID
WHERE T1.ContactID = 10
FOR XML PATH ('Person')


SELECT
	T1.FirstName as "*",
	T1.LastName as "*"
FROM Person.Contact T1
WHERE T1.ContactID = 10
FOR XML PATH ('Person')


SELECT 
	(
		SELECT ProductID as "data()"
		FROM Production.Product as T2
		WHERE T2.ProductSubcategoryID = T1.ProductSubcategoryID
		FOR XML PATH ('')
	) AS "@ProductIDs",

	T1.Name as "SubCategoryName",

	(
		SELECT [Name] as "ProductName"
		FROM Production.Product as T3
		WHERE T3.ProductSubcategoryID = T1.ProductSubcategoryID
		FOR XML PATH (''), TYPE
	) AS "ProductNames"

FROM Production.ProductSubcategory T1
WHERE T1.ProductSubcategoryID = 4 OR T1.ProductSubcategoryID = 6
FOR XML PATH ('SubCategories') 


-- deklaracja zmiennych
DECLARE @idoc int, @xmlDoc XML
-- definicja danych w formacie XML
SET @xmlDoc = 
CAST('
	 <Clients>
		<Client Genre="M" Name="FirstClient" />
		<Client Genre="F" Name="SecondClient" />
	</Clients>' as XML
	)

-- wczytanie danych XML do pamici serwera
EXEC sp_xml_preparedocument @idoc OUTPUT, @xmlDoc

-- pobranie atrybutw Genre i Name
SELECT *
FROM OPENXML (@idoc, '/Clients/Client', 0)
            WITH (Genre char, Name varchar(255))

-- usunicie danych z pamici serwera
EXEC sp_xml_removedocument @idoc


